package gov.va.med.mhv.phr.allergy.portlet;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.healthhistory.service.delegate.HealthHistoryServiceDelegate;
import gov.va.med.mhv.phr.allergy.decorator.AllergyDecorator;
import gov.va.med.mhv.phr.allergy.decorator.AllergyTableDecorator;
import gov.va.med.mhv.phr.allergy.model.AllergyBlendedRowSorter;
import gov.va.med.mhv.phr.allergy.model.AllergyRowSorter;
import gov.va.med.mhv.phr.allergy.model.AllergySEIRowSorter;
import gov.va.med.mhv.phr.form.AllergyForm;
import gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController;
import gov.va.med.mhv.phr.service.AllergyCollectionServiceResponse;
import gov.va.med.mhv.phr.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.phr.transfer.Allergy;
import gov.va.med.mhv.phr.util.SessionManagement;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.PatientServiceResponse;
import gov.va.med.mhv.usermgmt.service.UserProfileServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.ActivityAuditServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.InPersonAuthenticationServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.UserProfileServiceDelegate;
import gov.va.med.mhv.usermgmt.transfer.Activity;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.beehive.netui.pageflow.Forward;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.properties.SortOrderEnum;
import org.tigris.atlas.service.EntityCollectionServiceResponse;

import com.bea.portlet.PageURL;

@Jpf.Controller(strutsMerge = "/WEB-INF/struts-override.xml")
public class AllergyPageFlowController
    extends ExtractPageFlowBaseController
{
    private static final long serialVersionUID = 2066922212L;

    private static final Log LOG = LogFactory.getLog(
    		AllergyPageFlowController.class);

    private static final String ENTITY_NAME = StringUtils.substringAfterLast(
        Allergy.class.getName(), ".");

    private static final String HELP_PREFIX = "PHR_Allergy_";

    private static final String TABLE_UID = "Allergy";

    private static final String TABLE_SESSION_KEY =
        "gov.va.med.mhv.phr.allergy";

    public static final String AL_PAGE = "allergy";
    public static final String AL_PORTLET = "allergies_phr";
    public static final String ExtractURLPath = "/gov/va/med/mhv/phr/allergy/portlet/viewDetails";
    public static final String SEIURLPath = "/gov/va/med/mhv/phr/allergy/portlet/viewSEIDetails";

    private static final ExtractType EXTRACT_TYPE = ExtractType.getEnum(
        ExtractType.ALLERGY);

    private AllergyDecorator currentPanel = null;
    private static final String SEI_ALLERGY_PORTAL_PAGE = "allergies";

    @Override
    protected boolean allowAdvancedPatient(Patient patient) {
		// Adding for MVI Account Status Check
		Boolean isPatientAuthenticated = null;
    	InPersonAuthenticationServiceDelegate delegate = 
    		gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createInPersonAuthenticationServiceDelegate();
    	if (patient != null) {
    		isPatientAuthenticated = delegate.isPatientAuthenticated(patient.getId()).getBoolean();
    	}
    	
    	if(patient != null) {
    		if(patient.getMatchedDateTime() != null){
	    		if(isPatientAuthenticated != null) {
	    			if(isPatientAuthenticated == true && patient.getCorrelationStatus().equals(PatientCorrelationStatusUtils.CORRELATED))
	        			return false;
	    			else if(isPatientAuthenticated == true && !patient.getCorrelationStatus().equals(PatientCorrelationStatusUtils.CORRELATED)) {
	    	            SessionManagement.getInstance().setPatient(getRequest(), patient);
        				return true;
	    			}
	        		else if(isPatientAuthenticated == false) {
	    	            SessionManagement.getInstance().setPatient(getRequest(), patient);
        				return true;
	        		}
	    		}
	    		else {
    				return true;
	    		}
    		}else{
    			return false;
    		}
    	}
		return false;
    }

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "index.jsp"),
        @Jpf.Forward(name = "patient-not-ipa-ed",
            path="notInPersonAuthenticated.jsp"),
        @Jpf.Forward(name = "patient-not-correlated",
           path="../../common/notPatientCorrelated.jsp"),
        @Jpf.Forward(name = "failure", path = "index.jsp")
    })
    @Override
    public Forward begin() {
    	return super.begin();
    }
    
    protected final UserProfile getCurrentUserProfile() {
        UserProfileServiceDelegate delegate = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createUserProfileServiceDelegate();
		UserProfileServiceResponse response = delegate.getProfileForUser(getCurrentUserName());
		UserProfile up = response.getUserProfile();
		return up;
    }
    
    @Jpf.Action(
        forwards = { @Jpf.Forward(name = "success", action = "begin") }
    )
    public Forward refresh() {
        Forward forward = new Forward("success");
        return forward;
    }

    /**
     * Callback that is invoked when this controller instance is created.
     */
    @Override
    protected void onCreate() {
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getTableUID()
     */
    @Override
    public String getTableUID() {
        return TABLE_UID;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getDefaultSortProperty()
     */
    @Override
    public Integer getDefaultSortProperty() {
    	return 1;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.beehive.EntityPagingListPageFlowController#
     * getDefaultSortOrder()
     */
    @Override
    public SortOrderEnum getDefaultSortOrder() {
        return SortOrderEnum.DESCENDING;
    }

    public String getDecoratorClassName() {
        return AllergyTableDecorator.class.getName();
    }

    public String getSortClassName() {
        return AllergyRowSorter.class.getName();
    }


    /*
     * SEI Summary page Sorting
     */
    public String getSEISortClassName() {
        return AllergySEIRowSorter.class.getName();
    }

    public Integer getSEIDefaultSortProperty() {
    	return 1;
    }


    /*
     * Blended Summary page Sorting
     */
    public Integer getBlendedDefaultSortProperty() {
    	return 2;
    }

    public String getBlendedSortClassName() {
        return AllergyBlendedRowSorter.class.getName();
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityListMaintenancePageFlowController#
     * getTableSessionKey()
     */
    @Override
    protected String getTableSessionKey() {
        return TABLE_SESSION_KEY;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
     * getTransferObjectClass()
     */
    @Override
    protected Class getTransferObjectClass() {
        return Allergy.class;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.EntityMaintenancePageFlowController#
     * getEntityName()
     */
    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    /* (non-Javadoc)
     * @see org.tigris.atlas.beehive.AbstractPageFlowController#getFormClass()
     */
    @Override
    protected Class getFormClass() {
        return AllergyPageFlowController.class;
    }

    public AllergyDecorator getCurrentPanel() {
        return currentPanel;
    }

    @Jpf.Action(forwards = {
            @Jpf.Forward(name = "VASuccess", path = "index.jsp"),
            @Jpf.Forward(name = "nonVASuccess", path = "seiIndex.jsp"),
            @Jpf.Forward(name = "blendedSuccess", path = "blendedIndex.jsp"),
            @Jpf.Forward(name = "success", path = "index.jsp") }
    )
    public Forward allergySource(AllergyForm allergyForm) {
    	String allergySource = allergyForm.getAllergySource();

    	if(LOG.isDebugEnabled()){
    		LOG.debug("The selected Allergy Source " +
    				"for the patient " + getPatientId() + "is: " + allergySource);
    	}
        Forward forward = null;

    	if(allergySource.equalsIgnoreCase("B")){
    		this.getSession().setAttribute(AL_PORTLET+"summaryView", "blended");
            forward = new Forward("blendedSuccess");
            return forward;
    	}else if(allergySource.equalsIgnoreCase("NV")){
    		this.getSession().setAttribute(AL_PORTLET+"summaryView", "sei");
            forward = new Forward("nonVASuccess");
            return forward;
    	}else{
    		this.getSession().setAttribute(AL_PORTLET+"summaryView", "extract");
            forward = new Forward("VASuccess");
            return forward;
    	}
    }

    public String getCurrentSummaryView() {
    	String result = "extract";
    	String current = (String)this.getSession().getAttribute(AL_PORTLET+"summaryView");

    	if( null != current ) {
    		result = current;
    	}
    	return result;
    }

    public Collection<Allergy> getAllergyRecords() {
    	Collection<Allergy> result = new ArrayList<Allergy>();
    	Collection entities = this.getEntities();
    	if ( entities != null ) {
    		for(Object o : entities) {
    			result.add((Allergy)o);
    		}
    	}
    	return result;
    }

    public Collection<gov.va.med.mhv.healthhistory.transfer.Allergy> getSEIAllergyRecords() {
    	Collection<gov.va.med.mhv.healthhistory.transfer.Allergy> result = new ArrayList<gov.va.med.mhv.healthhistory.transfer.Allergy>();
    	Collection entities = this.getEntities();
    	if ( entities != null ) {
    		for(Object o : entities) {
    			result.add((gov.va.med.mhv.healthhistory.transfer.Allergy)o);
    		}
    	}
    	return result;
    }


    public boolean isPopulated() {
    	if(getExtractAllergyTableDecorators()!=null && getExtractAllergyTableDecorators().size()!=0){
    		return true;
    	}else{
    		return false;
    	}
    }

    @SuppressWarnings("unchecked")
    public Collection<AllergyTableDecorator> getExtractAllergyTableDecorators() {
    	Collection<AllergyTableDecorator> result =
            (Collection<AllergyTableDecorator>)getRequest().
            getAttribute("AllergyTableDecorators");
    	if ( result == null ) {
    		Collection<Allergy> entities = getAllergyRecords();
    		result = new ArrayList<AllergyTableDecorator>();
    		if ( entities != null ) {
    			for(Allergy extractRecord : entities) {
    	    		AllergyTableDecorator obj = new AllergyTableDecorator(extractRecord);
	    	    	obj.setDetailsLink(getURLWithActionOverride(ExtractURLPath, "id", obj.getId()));
	    	    	result.add(obj);
    			}
        	}
    		getRequest().setAttribute("AllergyTableDecorators", result);
    	}
        return result;
    }

    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "indexPF.jsp")}
    )
    public Forward viewPrinterFriendlyIndex() {
        return determineForward();
    }

    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "blendedIndexPF.jsp")}
    )
    public Forward viewBlendedPrinterFriendlyIndex() {
        return determineForward();
    }

    @Jpf.Action(
            forwards = {@Jpf.Forward(name = "success", path = "seiIndexPF.jsp")}
    )
    public Forward viewSEIPrinterFriendlyIndex() {
            return determineForward();
    }

    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "detailsPF.jsp")}
    )
    public Forward viewPrinterFriendlyDetails() {
    	handleMessages();
        return determineForward();
    }

    @Jpf.Action(
            forwards = {@Jpf.Forward(name = "success", path = "seiDetailsPF.jsp")}
    )
    public Forward viewSEIPrinterFriendlyDetails() {
    	handleSEIMessages();
        return determineForward();
    }


    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "index.jsp"),
        @Jpf.Forward(name = "viewSEISummary", path = "seiIndex.jsp"),
        @Jpf.Forward(name = "viewBlendedSummary", path = "blendedIndex.jsp")
    })
    @Override
    public Forward returnToListAction() {
    	String parameterValueFromJSP = getRequest().getParameter("returnToListParameterName");
    	if(parameterValueFromJSP!=null && parameterValueFromJSP.equalsIgnoreCase("extract")){
			currentPanel = null;
			handleMessages();
			return super.returnToListAction();
    	}else if(parameterValueFromJSP!=null && parameterValueFromJSP.equalsIgnoreCase("sei")){
			currentPanel = null;
			handleSEIMessages();
			return new Forward("viewSEISummary");
    	}else if(parameterValueFromJSP!=null && parameterValueFromJSP.equalsIgnoreCase("blended")){
			currentPanel = null;
			handleSEIMessages();
			return new Forward("viewBlendedSummary");
    	}else{
    		return new Forward("success");
    	}
    }

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "viewSummary", path = "returnToListAction.do"),
        @Jpf.Forward(name = "viewSEIDetails", path = "seiDetails.jsp"),
        @Jpf.Forward(name = "viewDetails", path = "details.jsp")
    })
    public Forward returnToViewAction() {
    	if (currentPanel != null) {
        	String parameterValueFromJSP = getRequest().getParameter("returnToListParameterName");
        	if(parameterValueFromJSP!=null && parameterValueFromJSP.equalsIgnoreCase("sei")){
    			this.handleSEIMessages();
    			return new Forward("viewSEIDetails");
        	}else{
        		this.handleMessages();
        		return new Forward("viewDetails");
        	}
    	}
    	String parameterValueFromJSP = getRequest().getParameter("returnToListParameterName");
    	if(parameterValueFromJSP!=null && parameterValueFromJSP.equalsIgnoreCase("sei")){
			this.handleSEIMessages();
    	}else{
    		this.handleMessages();
    	}
    	return new Forward("viewSummary");
    }


    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "details.jsp"),
        @Jpf.Forward(name = "failure", path = "index.jsp")
    })
    /**
     * Loads to the appropriate extract Allergy record details and forwards to the
     * associated details view page.
     * @return Forward denoting the details view
     */
    public Forward viewDetails() {
        Forward forward = null;

        Collection dashboardSession = (Collection)getSession().getAttribute(TABLE_SESSION_KEY);

        if(dashboardSession ==null){
            EntityCollectionServiceResponse response = loadExtract();
            getSession().setAttribute(TABLE_SESSION_KEY, response.getEntities());
        }

        Allergy allergy = findExtractAllergyRecordById(getDetailsId());
        if (allergy != null) {
            currentPanel = new AllergyDecorator(allergy);
            forward = determineForward();
        } else {
            forward = determineForwardOnUnknownEntity("view");
        }
        handleMessages();
        return forward;
    }

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success", path = "seiDetails.jsp"),
        @Jpf.Forward(name = "failure", path = "seiIndex.jsp")
    })
    /**
     * Loads to the appropriate SEI allergy record details and forwards to the
     * associated details view page.
     * @return Forward denoting the details view
     */
    public Forward viewSEIDetails() {
        Forward forward = null;
        gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergy = findSEIAllergyRecordById(getSEIDetailsId());
        if (seiAllergy != null) {
        	currentPanel = new AllergyDecorator(seiAllergy);
            forward = determineForward();
        } else {
            forward = determineForwardOnUnknownEntity("view");
        }
        return forward;
    }


    protected void handleMessages() {
    	if ( currentPanel != null && currentPanel.getMessages()!=null) {
    		if (currentPanel.getMessages().hasErrorMessages() || currentPanel.getMessages().hasInformationalMessages()) {
    			handleMessages(currentPanel.getMessages());
    		}
    	}
    }

    protected void handleSEIMessages() {
    	if(currentPanel != null && currentPanel.getMessages()!=null) {
    		if (currentPanel.getMessages().hasErrorMessages()) {
    			handleMessages(currentPanel.getMessages());
    		}
    	}else{
    			return;
    		}
    }

    private Long getDetailsId() {
        final String requestID = getRequest().getParameter("id");
        Precondition.assertNotBlank("request.id", requestID);
        Long id = null;
        try {
            id = Long.parseLong(requestID);
        } catch (NumberFormatException e) {
            Precondition.fail("request.id", "a Long", requestID,
                "Unable to determine id for selected allergy extract test record.");
        }
        return id;
    }

    private Long getSEIDetailsId() {
        final String requestID = getRequest().getParameter("SEIId");
        Precondition.assertNotBlank("request.id", requestID);
        Long id = null;
        try {
            id = Long.parseLong(requestID);
        } catch (NumberFormatException e) {
            Precondition.fail("request.id", "a Long", requestID,
                "Unable to determine id for selected SEI allergy test record in PHR.");
        }
        return id;
    }


    private Allergy findExtractAllergyRecordById(Long id) {
        Collection allergyRecords = getAllergyRecords();
        if (allergyRecords != null) {
            for(Object p: allergyRecords) {
                Allergy allergyRecord = (Allergy) p;
                if (id.equals(allergyRecord.getId())) {
                    return allergyRecord;
                }
            }
        }
        return null;
    }

    private gov.va.med.mhv.healthhistory.transfer.Allergy findSEIAllergyRecordById(Long id) {
    	HealthHistoryServiceDelegate svc = gov.va.med.mhv.healthhistory.service.delegate.ServiceDelegateFactory.createHealthHistoryServiceDelegate();
    	gov.va.med.mhv.healthhistory.service.AllergyCollectionServiceResponse allergySEIResponse = svc.findAllergiesForPatient(getCurrentUserId());
    	Collection<gov.va.med.mhv.healthhistory.transfer.Allergy> allergyRecords = allergySEIResponse.getAllergys();
        if (allergyRecords != null) {
            for(Object p: allergyRecords) {
            	gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergyRecord = (gov.va.med.mhv.healthhistory.transfer.Allergy) p;
                if (id.equals(seiAllergyRecord.getAllergyId())) {
                    return seiAllergyRecord;
                }
            }
        }
        return null;
    }


    @Jpf.Action(
        forwards = {@Jpf.Forward(name = "success", path = "index.jsp")}
    )
    public Forward handlePagingAndSorting() {
    	handleMessages();
        return super.handlePagingAndSorting();
    }
    
    @Jpf.Action(
            forwards = {@Jpf.Forward(name = "success", path = "seiIndex.jsp")}
        )
    public Forward handleSEIPagingAndSorting() {
    	handleSEIMessages();
        return super.handlePagingAndSorting();
    }    

    /* (non-Javadoc)
     */
    public String getSummaryHelpURI() {
        return createHelpURI(HELP_PREFIX + "VA_Summary.html");
    }

    /* (non-Javadoc)
     */
    public String getSEISummaryHelpURI() {
        return createHelpURI(HELP_PREFIX + "SEI_Summary.html");
    }

    /* (non-Javadoc)
     */
    public String getDetailsHelpURI() {
        return createHelpURI(HELP_PREFIX + "VA_Detail.html");
    }

    /* (non-Javadoc)
     */
    public String getSEIDetailsHelpURI() {
        return createHelpURI(HELP_PREFIX + "SEI_Detail.html");
    }

    /* (non-Javadoc)
     */
    public String getBlendedSummaryHelpURI() {
        return createHelpURI(HELP_PREFIX + "Blended_Summary.html");
    }

    /* (non-Javadoc)
     */
    public String getHistoryHelpURI() {
        return createHelpURI(HELP_PREFIX + "Record_History.html");
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractType()
     */
    @Override
    protected ExtractType getExtractType() {
        return EXTRACT_TYPE;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractName()
     */
    @Override
    public String getExtractName() {
        return "Allergies and Adverse Reactions";
    }


    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * getExtractDescription()
     */
    @Override
    protected String getExtractDescription() {
        return "Allergies and Adverse Reaction records";
    }


    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * loadExtract()
     */
    @Override
    protected EntityCollectionServiceResponse loadExtract() {
        return ServiceDelegateFactory.createAllergyBusinessServiceDelegate()
        .findAllergyRecordsByPatient(getPatient());
    }

    /*
     * (non-Javadoc)
     * @see gov.va.med.mhv.phr.portlet.ExtractPageFlowBaseController#
     * createExtractServiceResponse()
     */
    @Override
    protected EntityCollectionServiceResponse createExtractServiceResponse() {
        return new AllergyCollectionServiceResponse();
    }

    @Jpf.Action(forwards = {
        @Jpf.Forward(name = "success",
            path="../../common/notInPersonAuthenticated.jsp")
    })
    @Override
    public Forward showNotInPersonAuthenticated() {
        return super.showNotInPersonAuthenticated();
    }

    /*
     * Set the URL for the links in blended view summary page
     */
    public String getURLWithActionOverride(String URLPath, String param, long id) {
		PageURL url = PageURL.createPageURL(getRequest(), getResponse(), AL_PAGE);
		url.addParameter(AL_PORTLET + "_actionOverride", URLPath, false, false);
		url.addParameter(AL_PORTLET + param, Long.toString(id), false, false);

    	if(LOG.isDebugEnabled()){
    		LOG.debug("*** The URL in getURLWithActionOverride method " +
    				"for the patient " + getPatientId() + "is" + url.toString());
    	}
		return url.toString();
	}

    /**
     * SEI Allergy Summary view
     */
    @SuppressWarnings("unchecked")
    public Collection<AllergyTableDecorator> getSEIAllergyTableDecorators(){
    	HealthHistoryServiceDelegate svc = gov.va.med.mhv.healthhistory.service.delegate.ServiceDelegateFactory.createHealthHistoryServiceDelegate();
    	gov.va.med.mhv.healthhistory.service.AllergyCollectionServiceResponse allergySEIResponse = svc.findAllergiesForPatient(getCurrentUserId());
    	Collection<gov.va.med.mhv.healthhistory.transfer.Allergy> seiAllergies = allergySEIResponse.getAllergys();
    	if(LOG.isDebugEnabled()){
    		LOG.debug("*** The size of SEI Allergy collection in getSEIAllergyTableDecorators method " +
    				"for the patient " + getPatientId() + "is" + seiAllergies.size());
    	}

    	Collection<AllergyTableDecorator> result = new ArrayList<AllergyTableDecorator>();
    	for(gov.va.med.mhv.healthhistory.transfer.Allergy seiAllergyRecord : seiAllergies ) {
       		AllergyTableDecorator obj = new AllergyTableDecorator(seiAllergyRecord);
    	    obj.setDetailsLink(getURLWithActionOverride(SEIURLPath, "SEIId", obj.getSEIId()));
    		result.add(obj);
    	}
    	return result;
    }

    /**
     * Blended Allergy Summary view
     */
    @SuppressWarnings("unchecked")
    public Collection<AllergyTableDecorator> getBlendedAllergyTableDecorators(){
    	List blendedList = new ArrayList();
    	blendedList.addAll(getExtractAllergyTableDecorators());
    	blendedList.addAll(getSEIAllergyTableDecorators());
    	if(LOG.isDebugEnabled()){
    		LOG.debug("*** The size of blendedList in getBlendedAllergyTableDecorators" +
    				"method for the patient " + getPatientId() + "is " + blendedList.size());
    	}
    	return blendedList;
    }

    /*
     * Take the response to SEI Allergies page in MHV portal
     */
    public String getSEIAllergyUrl() {
        PageURL url = PageURL.createPageURL(getRequest(), getResponse());
        url.setPageLabel(SEI_ALLERGY_PORTAL_PAGE);
        return getResponse().encodeURL(url.toString());
    }

    @Override
	protected void auditView() {
		ActivityAuditServiceDelegate auditDelegate =
		gov.va.med.mhv.usermgmt.service.delegate.
         ServiceDelegateFactory.createActivityAuditServiceDelegate();

		Activity activity =
			TransferObjectFactory.createActivity();

		activity.setAction(ActivityActionTypeEnumeration
							.getEnum(ActivityActionTypeEnumeration.VIEW));
		activity.setActionType(ActivityTypeEnumeration.ALLERGY);
		activity.setPerformerType(ActivityActorTypeEnumeration
							.getEnum(ActivityActorTypeEnumeration.SELF));
		activity.setSubjectId(getCurrentUserId());
		activity.setCompletionTime(new java.sql.Timestamp(
							java.util.Calendar.getInstance().getTimeInMillis()));
		activity.setStatus(Boolean.TRUE);

		auditDelegate.audit(activity);
	}
}